/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;

public class DesertRhinoEntity
extends Monster {
    private int sprintedTicker = 0;

    public DesertRhinoEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 30;
    }

    public static AttributeSupplier.Builder createDesertRhinoAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.26).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22282_, 2.2).m_22268_(Attributes.f_22277_, 38.0);
    }

    public static boolean canSpawn(EntityType<DesertRhinoEntity> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return (world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49992_) || world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50062_)) && world.m_45524_(pos, 0) > 8 && world.m_45527_(pos) && world.m_6443_(DesertRhinoEntity.class, new AABB(pos).m_82400_(120.0), EntitySelector.f_20408_).isEmpty() && world.m_213780_().m_188501_() < 0.5f || spawnReason == MobSpawnType.SPAWNER;
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SprintAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HeadAttackGoal((PathfinderMob)this, 1.1, true));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.85));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{DesertRhinoEntity.class}));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    public void m_8097_() {
        super.m_8097_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.sprintedTicker > 0) {
            --this.sprintedTicker;
        }
    }

    public boolean m_6785_(double num) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public boolean m_6072_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundInit.DESERT_RHINO_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.DESERT_RHINO_HIT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.DESERT_RHINO_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundInit.DESERT_RHINO_WALK_EVENT, 0.8f, 1.0f);
    }

    public boolean m_7327_(Entity target) {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundInit.DESERT_RHINO_ATTACK_EVENT, SoundSource.HOSTILE, 1.0f, 1.0f);
        return super.m_7327_(target);
    }

    private class SprintAttackGoal
    extends Goal {
        private final DesertRhinoEntity desertRhinoEntity;
        private Path path;
        private BlockPos targetPos;
        private int cooldown;

        public SprintAttackGoal(DesertRhinoEntity desertRhinoEntity2) {
            this.desertRhinoEntity = desertRhinoEntity2;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.cooldown-- > 0) {
                return false;
            }
            LivingEntity livingEntity = this.desertRhinoEntity.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            this.path = this.desertRhinoEntity.m_21573_().m_6570_((Entity)livingEntity, 0);
            if (this.path != null && this.path.m_77403_()) {
                this.targetPos = new BlockPos((Vec3i)this.path.m_77406_());
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.desertRhinoEntity.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            if (!this.desertRhinoEntity.m_21444_(livingEntity.m_20183_())) {
                return false;
            }
            if (this.desertRhinoEntity.m_20275_(this.targetPos.m_123341_(), this.targetPos.m_123342_(), this.targetPos.m_123343_()) < 10.0) {
                return false;
            }
            return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
        }

        public void m_8056_() {
            this.desertRhinoEntity.m_21573_().m_26536_(this.path, 1.5);
        }

        public void m_8041_() {
            this.cooldown = 100 + this.desertRhinoEntity.m_9236_().m_213780_().m_188503_(300);
            LivingEntity livingEntity = this.desertRhinoEntity.m_5448_();
            if (livingEntity != null) {
                this.attack(livingEntity, this.desertRhinoEntity.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_()));
            }
            this.desertRhinoEntity.m_21561_(false);
            this.desertRhinoEntity.sprintedTicker = 40;
        }

        private void attack(LivingEntity target, double squaredDistance) {
            double d = this.desertRhinoEntity.m_20205_() * 2.25f * this.desertRhinoEntity.m_20205_() * 2.25f + target.m_20205_() * 1.25f;
            if (squaredDistance <= d) {
                this.desertRhinoEntity.m_6674_(InteractionHand.MAIN_HAND);
                this.desertRhinoEntity.m_21051_(Attributes.f_22282_).m_22100_(this.desertRhinoEntity.m_21133_(Attributes.f_22282_) + 10.0);
                BlockPos attackedPos = this.desertRhinoEntity.m_7327_((Entity)target) ? BlockPos.m_274561_((double)target.m_20185_(), (double)target.m_20186_(), (double)target.m_20189_()) : this.targetPos;
                if (!this.desertRhinoEntity.m_9236_().m_8055_(attackedPos.m_7495_()).m_60795_()) {
                    for (int i = 0; i < 30; ++i) {
                        ((ServerLevel)this.desertRhinoEntity.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.desertRhinoEntity.m_9236_().m_8055_(attackedPos.m_7495_())), (double)attackedPos.m_123341_() + this.desertRhinoEntity.m_9236_().m_213780_().m_188500_() * 2.5 - 1.25, (double)attackedPos.m_123342_() + this.desertRhinoEntity.m_9236_().m_213780_().m_188500_() * 0.2, (double)attackedPos.m_123343_() + this.desertRhinoEntity.m_9236_().m_213780_().m_188500_() * 2.5 - 1.25, 4, 0.0, this.desertRhinoEntity.m_9236_().m_213780_().m_188500_() * 0.15, 0.0, 1.0);
                    }
                }
                this.desertRhinoEntity.m_21051_(Attributes.f_22282_).m_22100_(this.desertRhinoEntity.m_21133_(Attributes.f_22282_) - 10.0);
            }
        }
    }

    private class HeadAttackGoal
    extends MeleeAttackGoal {
        private final DesertRhinoEntity desertRhinoEntity;

        public HeadAttackGoal(PathfinderMob mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
            this.desertRhinoEntity = (DesertRhinoEntity)mob;
        }

        public boolean m_8036_() {
            if (this.desertRhinoEntity.sprintedTicker > 0) {
                return false;
            }
            return super.m_8036_();
        }

        protected double m_6639_(LivingEntity entity) {
            return this.f_25540_.m_20205_() * 1.6f * this.f_25540_.m_20205_() * 1.6f + entity.m_20205_();
        }
    }
}

